import { View, Text, Pressable } from "react-native";
import React from "react";
import { EditProfileStyle } from "../../../../Profile/EditProfile/StyleEditProfile";
import { productDetailsStyle } from "../ProductDetailsStyle";
import dpr from "../../../../Utilities/CustomStyleAttribute/dpr";
import AddToCart from "../../../../../assets/svgs/product details/addtocart.svg";
import * as Linking from "expo-linking";
import CustomSVG from "../../../../../src/components/CustomSVG/CustomSVG";

const Affiliate = ({ external_products }) => {
    const { text, url } = external_products || {};
    return (
        <View style={EditProfileStyle.changeInfo}>
            <Pressable
                disabled={url != "" ? false : true}
                onPress={() => Linking.openURL(url)}
            >
                <View
                    style={[
                        productDetailsStyle.addToCart,
                        productDetailsStyle.addToCartContAffiliate,
                        productDetailsStyle.addToCartContAffiliateColor(url)
                    ]}
                >
                    <CustomSVG svgIcon={AddToCart} height={dpr(22)} width={dpr(18)} />
                    <Text style={productDetailsStyle.cartBtnText}>
                        {text}
                    </Text>
                </View>
            </Pressable>
        </View>
    );
};

export default Affiliate;
